"use client"
import React, { useState } from 'react'
import HeroSection from '../components/HeroSection'
import InputField from './components/InputField'
import PhoneInput from './components/PhoneInput'
import RadioGroup from './components/RadioGroup'
import axiosInstance from '@/api/axiosInstance'

const countries = [
  // Arabic countries at the top
  { name: 'سوريا', prefix: '+963' },
  { name: 'السعودية', prefix: '+966' },
  { name: 'مصر', prefix: '+20' },
  { name: 'العراق', prefix: '+964' },
  { name: 'الأردن', prefix: '+962' },
  { name: 'لبنان', prefix: '+961' },
  { name: 'فلسطين', prefix: '+970' },
  { name: 'اليمن', prefix: '+967' },
  { name: 'ليبيا', prefix: '+218' },
  { name: 'الجزائر', prefix: '+213' },
  { name: 'المغرب', prefix: '+212' },
  { name: 'تونس', prefix: '+216' },
  { name: 'السودان', prefix: '+249' },
  { name: 'الصومال', prefix: '+252' },
  { name: 'موريتانيا', prefix: '+222' },
  { name: 'عمان', prefix: '+968' },
  { name: 'الإمارات العربية المتحدة', prefix: '+971' },
  { name: 'قطر', prefix: '+974' },
  { name: 'البحرين', prefix: '+973' },
  { name: 'الكويت', prefix: '+965' },
  { name: 'جيبوتي', prefix: '+253' },
  { name: 'جزر القمر', prefix: '+269' },
  
  // Rest of the world (alphabetically)
  { name: 'أفغانستان', prefix: '+93' },
  { name: 'ألبانيا', prefix: '+355' },
  { name: 'أندورا', prefix: '+376' },
  { name: 'أنغولا', prefix: '+244' },
  { name: 'أنتيغوا وباربودا', prefix: '+1-268' },
  { name: 'الأرجنتين', prefix: '+54' },
  { name: 'أرمينيا', prefix: '+374' },
  { name: 'أستراليا', prefix: '+61' },
  { name: 'النمسا', prefix: '+43' },
  { name: 'أذربيجان', prefix: '+994' },
  { name: 'باهاماس', prefix: '+1-242' },
  { name: 'بنغلاديش', prefix: '+880' },
  { name: 'باربادوس', prefix: '+1-246' },
  { name: 'بيلاروسيا', prefix: '+375' },
  { name: 'بلجيكا', prefix: '+32' },
  { name: 'بليز', prefix: '+501' },
  { name: 'بنين', prefix: '+229' },
  { name: 'بوتان', prefix: '+975' },
  { name: 'بوليفيا', prefix: '+591' },
  { name: 'البوسنة والهرسك', prefix: '+387' },
  { name: 'بوتسوانا', prefix: '+267' },
  { name: 'البرازيل', prefix: '+55' },
  { name: 'بروناي', prefix: '+673' },
  { name: 'بلغاريا', prefix: '+359' },
  { name: 'بوركينا فاسو', prefix: '+226' },
  { name: 'بوروندي', prefix: '+257' },
  { name: 'الرأس الأخضر', prefix: '+238' },
  { name: 'كمبوديا', prefix: '+855' },
  { name: 'الكاميرون', prefix: '+237' },
  { name: 'كندا', prefix: '+1' },
  { name: 'جمهورية أفريقيا الوسطى', prefix: '+236' },
  { name: 'تشاد', prefix: '+235' },
  { name: 'تشيلي', prefix: '+56' },
  { name: 'الصين', prefix: '+86' },
  { name: 'كولومبيا', prefix: '+57' },
  { name: 'جمهورية الكونغو', prefix: '+242' },
  { name: 'جمهورية الكونغو الديمقراطية', prefix: '+243' },
  { name: 'كوستاريكا', prefix: '+506' },
  { name: 'ساحل العاج', prefix: '+225' },
  { name: 'كرواتيا', prefix: '+385' },
  { name: 'كوبا', prefix: '+53' },
  { name: 'قبرص', prefix: '+357' },
  { name: 'التشيك', prefix: '+420' },
  { name: 'الدنمارك', prefix: '+45' },
  { name: 'دومينيكا', prefix: '+1-767' },
  { name: 'جمهورية الدومينيكان', prefix: '+1-809' },
  { name: 'تيمور الشرقية', prefix: '+670' },
  { name: 'الإكوادور', prefix: '+593' },
  { name: 'السلفادور', prefix: '+503' },
  { name: 'غينيا الاستوائية', prefix: '+240' },
  { name: 'إريتريا', prefix: '+291' },
  { name: 'إستونيا', prefix: '+372' },
  { name: 'إسواتيني', prefix: '+268' },
  { name: 'إثيوبيا', prefix: '+251' },
  { name: 'فيجي', prefix: '+679' },
  { name: 'فنلندا', prefix: '+358' },
  { name: 'فرنسا', prefix: '+33' },
  { name: 'الغابون', prefix: '+241' },
  { name: 'غامبيا', prefix: '+220' },
  { name: 'جورجيا', prefix: '+995' },
  { name: 'ألمانيا', prefix: '+49' },
  { name: 'غانا', prefix: '+233' },
  { name: 'اليونان', prefix: '+30' },
  { name: 'غرينادا', prefix: '+1-473' },
  { name: 'غواتيمالا', prefix: '+502' },
  { name: 'غينيا', prefix: '+224' },
  { name: 'غينيا بيساو', prefix: '+245' },
  { name: 'غيانا', prefix: '+592' },
  { name: 'هايتي', prefix: '+509' },
  { name: 'هندوراس', prefix: '+504' },
  { name: 'المجر', prefix: '+36' },
  { name: 'آيسلندا', prefix: '+354' },
  { name: 'الهند', prefix: '+91' },
  { name: 'إندونيسيا', prefix: '+62' },
  { name: 'إيران', prefix: '+98' },
  { name: 'أيرلندا', prefix: '+353' },
  { name: 'إسرائيل', prefix: '+972' },
  { name: 'إيطاليا', prefix: '+39' },
  { name: 'جامايكا', prefix: '+1-876' },
  { name: 'اليابان', prefix: '+81' },
  { name: 'كازاخستان', prefix: '+7' },
  { name: 'كينيا', prefix: '+254' },
  { name: 'كيريباتي', prefix: '+686' },
  { name: 'كوريا الشمالية', prefix: '+850' },
  { name: 'كوريا الجنوبية', prefix: '+82' },
  { name: 'قيرغيزستان', prefix: '+996' },
  { name: 'لاوس', prefix: '+856' },
  { name: 'لاتفيا', prefix: '+371' },
  { name: 'ليسوتو', prefix: '+266' },
  { name: 'ليبيريا', prefix: '+231' },
  { name: 'ليختنشتاين', prefix: '+423' },
  { name: 'ليتوانيا', prefix: '+370' },
  { name: 'لوكسمبورغ', prefix: '+352' },
  { name: 'مدغشقر', prefix: '+261' },
  { name: 'مالاوي', prefix: '+265' },
  { name: 'ماليزيا', prefix: '+60' },
  { name: 'جزر المالديف', prefix: '+960' },
  { name: 'مالي', prefix: '+223' },
  { name: 'مالطا', prefix: '+356' },
  { name: 'جزر مارشال', prefix: '+692' },
  { name: 'موريشيوس', prefix: '+230' },
  { name: 'المكسيك', prefix: '+52' },
  { name: 'ولايات ميكرونيسيا المتحدة', prefix: '+691' },
  { name: 'مولدوفا', prefix: '+373' },
  { name: 'موناكو', prefix: '+377' },
  { name: 'منغوليا', prefix: '+976' },
  { name: 'الجبل الأسود', prefix: '+382' },
  { name: 'موزمبيق', prefix: '+258' },
  { name: 'ميانمار', prefix: '+95' },
  { name: 'ناميبيا', prefix: '+264' },
  { name: 'ناورو', prefix: '+674' },
  { name: 'نيبال', prefix: '+977' },
  { name: 'هولندا', prefix: '+31' },
  { name: 'نيوزيلندا', prefix: '+64' },
  { name: 'نيكاراغوا', prefix: '+505' },
  { name: 'النيجر', prefix: '+227' },
  { name: 'نيجيريا', prefix: '+234' },
  { name: 'مقدونيا الشمالية', prefix: '+389' },
  { name: 'النرويج', prefix: '+47' },
  { name: 'باكستان', prefix: '+92' },
  { name: 'بالاو', prefix: '+680' },
  { name: 'بنما', prefix: '+507' },
  { name: 'بابوا غينيا الجديدة', prefix: '+675' },
  { name: 'باراغواي', prefix: '+595' },
  { name: 'بيرو', prefix: '+51' },
  { name: 'الفلبين', prefix: '+63' },
  { name: 'بولندا', prefix: '+48' },
  { name: 'البرتغال', prefix: '+351' },
  { name: 'رومانيا', prefix: '+40' },
  { name: 'روسيا', prefix: '+7' },
  { name: 'رواندا', prefix: '+250' },
  { name: 'سانت كيتس ونيفيس', prefix: '+1-869' },
  { name: 'سانت لوسيا', prefix: '+1-758' },
  { name: 'سانت فنسنت والغرينادين', prefix: '+1-784' },
  { name: 'ساموا', prefix: '+685' },
  { name: 'سان مارينو', prefix: '+378' },
  { name: 'ساو تومي وبرينسيب', prefix: '+239' },
  { name: 'السنغال', prefix: '+221' },
  { name: 'صربيا', prefix: '+381' },
  { name: 'سيشل', prefix: '+248' },
  { name: 'سيراليون', prefix: '+232' },
  { name: 'سنغافورة', prefix: '+65' },
  { name: 'سلوفاكيا', prefix: '+421' },
  { name: 'سلوفينيا', prefix: '+386' },
  { name: 'جزر سليمان', prefix: '+677' },
  { name: 'جنوب أفريقيا', prefix: '+27' },
  { name: 'جنوب السودان', prefix: '+211' },
  { name: 'إسبانيا', prefix: '+34' },
  { name: 'سريلانكا', prefix: '+94' },
  { name: 'سورينام', prefix: '+597' },
  { name: 'السويد', prefix: '+46' },
  { name: 'سويسرا', prefix: '+41' },
  { name: 'تايوان', prefix: '+886' },
  { name: 'طاجيكستان', prefix: '+992' },
  { name: 'تنزانيا', prefix: '+255' },
  { name: 'تايلاند', prefix: '+66' },
  { name: 'توغو', prefix: '+228' },
  { name: 'تونغا', prefix: '+676' },
  { name: 'ترينيداد وتوباغو', prefix: '+1-868' },
  { name: 'تركيا', prefix: '+90' },
  { name: 'تركمانستان', prefix: '+993' },
  { name: 'توفالو', prefix: '+688' },
  { name: 'أوغندا', prefix: '+256' },
  { name: 'أوكرانيا', prefix: '+380' },
  { name: 'المملكة المتحدة', prefix: '+44' },
  { name: 'الولايات المتحدة', prefix: '+1' },
  { name: 'أوروغواي', prefix: '+598' },
  { name: 'أوزبكستان', prefix: '+998' },
  { name: 'فانواتو', prefix: '+678' },
  { name: 'الفاتيكان', prefix: '+379' },
  { name: 'فنزويلا', prefix: '+58' },
  { name: 'فيتنام', prefix: '+84' },
  { name: 'زامبيا', prefix: '+260' },
  { name: 'زيمبابوي', prefix: '+263' }
];

const SendQuestion = () => {
  const [question, setQuestion] = useState({
    name: '',
    job: '',
    email: '',
    phone: '',
    age: '',
    country: '',
    publication: '',
    gender: '',
  })
  const [error, setError] = useState("")
  const [success, setSuccess] = useState("")

  const handleInputChange = (e) => {
    const { name, value } = e.target;
    setQuestion(prev => ({ ...prev, [name]: value }));
  }

  const handlePhoneChange = (prefix, localPhone) => {
    const completePhone = prefix + localPhone
    setQuestion({...question, phone: completePhone})
  }  

  // Handle submit
  const handleSubmit = async (e) => {
     e.preventDefault();
      if(question.visibility === "private" && question.email === "" && question.phone === ""){
    setError("⚠️ السؤال خاص: يرجى تعبئة البريد الإلكتروني أو رقم الهاتف للتواصل معك");
    setSuccess("")
    return;
  }
    try{
    const res = await axiosInstance.post("/questions",{...question, status: "pending"});
    console.log("Api response", res.data)
    setSuccess("تم ارسال السؤال بنجاح")
    setError("")
    }catch(error){
      console.log("error", error)
    }
   
  }

  const visibilityOptions = [
    { value: 'private', label: 'سؤال خاص' },
    { value: 'public', label: 'متاح للعامة' }
  ]

  const genderOptions = [
    { value: 'female', label: 'أنثى' },
    { value: 'male', label: 'ذكر' }
  ]

  return (
    <div className='font-amiri pt-16 min-h-screen'>
      <HeroSection title="إرسال سؤال شرعي" image="/download (3).png" />
      
      <div className="my-8 w-full">
        <form 
          className="flex flex-col justify-center items-center gap-6 lg:px-12 md:px-8 px-5"
          onSubmit={handleSubmit}
        >
          {/* Optional Fields */}
          <div className="grid grid-cols-1 md:grid-cols-2 gap-6 w-full">
            <InputField
              label="الاسم (اختياري)"
              name="name"
              value={question.name}
              onChange={handleInputChange}
              placeholder="أدخل اسمك"
            />
            <InputField
              label="العمل (اختياري)"
              name="job"
              value={question.job}
              onChange={handleInputChange}
              placeholder="أدخل عملك"
            />
          </div>

          <hr className="w-full border-t border-gray-300 my-2" />
          
          {/* Contact Information */}
          <div className="grid grid-cols-1 md:grid-cols-2 gap-6 w-full">
            <InputField
              label="البريد الالكتروني"
              name="email"
              type="email"
              value={question.email}
              onChange={handleInputChange}
              placeholder="example@email.com"
            />
            <PhoneInput
              countries={countries}
              onPhoneChange={handlePhoneChange}
            />
          </div>

          <hr className="w-full border-t border-gray-300 my-2" />

          {/* Required Fields */}
          <div className="grid grid-cols-1 md:grid-cols-2 gap-6 w-full">
            <InputField
              label="العمر (مطلوب)"
              name="age"
              type="number"
              value={question.age}
              onChange={handleInputChange}
              required={true}
              placeholder="أدخل عمرك"
            />
            
            <div className="space-y-2">
              <label className="block text-sm font-medium text-quaternary">
                الدولة (مطلوب) *
              </label>
              <select
                name="country"
                value={question.country}
                onChange={handleInputChange}
                required
                className="w-full px-4 py-3 border border-secondary rounded-xl focus:ring-2 focus:ring-primary focus:border-transparent transition-all duration-200 bg-white appearance-none pr-8 cursor-pointer"
              >
                <option value="" disabled>اختر الدولة</option>
                {countries.map((country) => (
                  <option key={country.name} value={country.name}>
                    {country.name}
                  </option>
                ))}
              </select>
            </div>
          </div>

          <hr className="w-full border-t border-gray-300 my-2" />
          
          {/* Radio Groups */}
          <RadioGroup
            label="إمكانية النشر (مطلوب)"
            name="visibility"
            value={question.visibility}
            onChange={handleInputChange}
            options={visibilityOptions}
            required={true}
            description="عند اختيارك سؤال خاص يجب تعبئة حقل البريد الالكتروني أو رقم الهاتف."
          />

          <hr className="w-full border-t border-gray-300 my-2" />
          
          <RadioGroup
            label="الجنس (مطلوب)"
            name="gender"
            value={question.gender}
            onChange={handleInputChange}
            options={genderOptions}
            required={true}
          />

          <hr className="w-full border-t border-gray-300 my-2" />

          {/* Question Textarea */}
          <div className="w-full space-y-2">
            <label className="block text-sm font-medium text-quaternary">
              السؤال (مطلوب) *
            </label>
            <textarea
              name="question"
              value={question.question}
              onChange={handleInputChange}
              required
              rows={6}
              className="w-full px-4 py-3 border border-secondary rounded-xl focus:ring-2 focus:ring-primary focus:border-transparent transition-all duration-200 bg-white resize-y"
              placeholder="اكتب سؤالك هنا..."
            ></textarea>
          </div>

          {/* show error */}
          {error ? (
            <div className="text-red-600 text-center font-bold">{error}</div>
          ) : ""}
          {/* show success */}
            {success ? (
            <div className="text-primary text-center font-bold">{success}</div>
          ) : ""}
          {/* Submit Button */}
          <div className="flex justify-center pt-4 w-full">
            <button
              type="submit"
              className="text-white cursor-pointer bg-primary px-12 py-4 rounded-xl shadow-md hover:shadow-lg transition duration-300 font-medium text-lg focus:outline-none focus:ring-4 focus:ring-primary focus:ring-opacity-50"
            >
              ارسال السؤال
            </button>
          </div>
        </form>
      </div>
    </div>
  )
}

export default SendQuestion;