
const RadioGroup = ({ 
  label, 
  name, 
  value, 
  onChange, 
  options, 
  required = false,
  description 
}) => (
  <div className='w-full flex flex-col items-start justify-center'>
    <label className="block text-sm font-medium mb-2 text-quaternary">
      {label} {required && '*'}
    </label>
    <div className='flex flex-wrap gap-4'>
      {options.map((option) => (
        <label 
          key={option.value}
          className="flex items-center p-3 rounded-lg hover:bg-gray-100 transition duration-200 cursor-pointer border border-transparent has-[:checked]:border-secondary"
        >
          <input
            type="radio"
            name={name}
            value={option.value}
            checked={value === option.value}
            onChange={onChange}
            required={required}
            className="h-4 w-4 text-primary"
            style={{ accentColor: '#2E7D32' }}
          />
          <span className="mr-3 text-quaternary">{option.label}</span>
        </label>
      ))}
    </div>
    {description && (
      <p className="text-sm text-gray-600 mt-3 p-2 bg-white rounded-lg border border-gray-200">
        {description}
      </p>
    )}
  </div>
);

export default RadioGroup;