"use client"
import { useState } from "react";

const PhoneInput = ({ countries, onPhoneChange }) => {
const [selectedCountryKey, setSelectedCountryKey] = useState('+963')
const [localPhone, setLocalPhone] = useState("")
  return (
    <div className='space-y-2'>
      <label className="block text-sm font-medium text-quaternary">
        رقم الهاتف
      </label>
      <div className="flex rounded-xl overflow-hidden border border-secondary">
        <input
          type="tel"
          name="phone"
          className="flex-1 px-2 py-3 bg-white focus:ring-0 focus:outline-none rounded-r-xl rounded-l-none w-full" 
          placeholder="رقم الهاتف"
          value={localPhone}
          onChange={(e) => {
            const newLocalPhone = e.target.value
            setLocalPhone(newLocalPhone);
            onPhoneChange(selectedCountryKey, newLocalPhone)
        }}
        />
        <div className="relative border-l border-secondary/50 w-[90px] "> 
          <select
            className=" py-3 bg-secondary/20 text-gray-700 h-full appearance-none pr-8 cursor-pointer rounded-l-xl rounded-r-none w-[100px]"
            value={selectedCountryKey}
            onChange={(e) => {
            const newCountryKey = e.target.value    
            setSelectedCountryKey(newCountryKey)
            onPhoneChange(newCountryKey, localPhone)
        }}
          >
            {countries.map((country) => (
              <option key={country.name} value={country.prefix}>
                {country.prefix}
              </option>
            ))}
          </select>
        </div>
      </div>
    </div>
  );
};

export default PhoneInput;