
const InputField = ({ 
  label, 
  name, 
  value, 
  onChange, 
  type = 'text', 
  required = false, 
  placeholder,
  className = ''
}) => (
  <div className='space-y-2'>
    <label className="block text-sm font-medium text-quaternary">
      {label} {required && '*'}
    </label>
    <input
      type={type}
      name={name}
      value={value}
      onChange={onChange}
      required={required}
      className={`w-full px-4 py-3 border border-secondary rounded-xl focus:ring-2 focus:ring-primary focus:border-transparent transition-all duration-200 bg-white ${className}`}
      placeholder={placeholder}
    />
  </div>
);

export default InputField;