import Link from 'next/link'
import React from 'react'

const QuestionsSection = ({questions}) => {
  return (
    <div className='font-amiri flex flex-col items-center justify-center gap-3 lg:px-12 md:px-8 px-5'>
        <h1 className='text-quaternary text-3xl font-extrabold'>الأسئلة</h1>
        {/* divider */}
        <div className='h-0.5 w-full bg-quaternary/30'></div>
        {questions.length === 0 ? (
             <p className='text-xl font-bold my-4 text-quaternary'>لا توجد أسئلة حاليا</p>
        ) : (
         <div className='grid grid-cols-1 w-full my-5 gap-3'>
            {questions.map((question) => {
                return(
                <Link key={question.id} href={`/question/${question.id}`}>
                    <div className='w-full h-fit rounded-xl shadow-md px-3 py-2 bg-tertiary'>
                        {/* title */}
                        <div className='text-xl font-bold py-2 line-clamp-3 hover:text-primary'>
                            {question.id} - {question.title}
                        </div>
                        {/* divider */}
                        <div className='h-0.5 w-full bg-quaternary/30'></div>
                        <div className='text-lg font-medium py-2 line-clamp-3'>{question.body}</div>
                    </div>
                </Link>
                )
            })}
        </div>
        )}
       
    </div>
  )
}

export default QuestionsSection