import Footer from "./components/Footer";
import Header from "./components/Header/Header";
import "./globals.css";
import "slick-carousel/slick/slick.css";
import "slick-carousel/slick/slick-theme.css";


export const viewport = {
  width: 'device-width',
  initialScale: 1,
};

export const metadata = {
  title: "موقع الشيخ محمد خير الشعّال",
  description:
    "دروس، محاضرات، وخطب إسلامية للشيخ محمد خير الشعّال مع إمكانية طرح الأسئلة الشرعية والحصول على إجابات موثوقة.",
  keywords: [
    "محمد خير الشعّال",
    "دروس إسلامية",
    "محاضرات",
    "خطب",
    "أسئلة شرعية",
    "فتاوى",
    "القرآن",
    "الإسلام",
  ],
  authors: [{ name: "الشيخ محمد خير الشعّال" }],
  
  // Open Graph (Facebook, WhatsApp, Telegram, etc.)
  openGraph: {
    title: "موقع الشيخ محمد خير الشعّال",
    description:
      "دروس، محاضرات، وخطب إسلامية للشيخ محمد خير الشعّال مع إمكانية طرح الأسئلة الشرعية والحصول على إجابات موثوقة.",
    url: "https://shaal.zumurd.com",
    siteName: "موقع الشيخ محمد خير الشعّال",
    images: [
      {
        url: "/logo.png",
        width: 1200,   // Recommended size for social sharing
        height: 630,
        alt: "الشيخ محمد خير الشعّال",
      },
    ],
    locale: "ar_AR",
    type: "website",
  },

  // Twitter Card
  twitter: {
    card: "summary_large_image",
    title: "موقع الشيخ محمد خير الشعّال",
    description:
      "دروس، محاضرات، وخطب إسلامية للشيخ محمد خير الشعّال مع إمكانية طرح الأسئلة الشرعية والحصول على إجابات موثوقة.",
    images: ["/logo.png"],
  },

  // Icons
  icons: {
    icon: "/logo.png",  
    shortcut: "/logo.png",   
  },

  metadataBase: new URL("https://shaal.zumurd.com"),
  alternates: {
    canonical: "https://shaal.zumurd.com",
  },
};

export default function RootLayout({ children }) {
  return (
    <html lang="ar" dir="rtl">
      <body>
        <Header />
        {children}
        <Footer />
      </body>
    </html>
  );
}
