import React from 'react'
import Image from 'next/image'
const HeroSection = ({title, length, type, image}) => {
  return (
     <div className="relative w-full h-[220px] bg-center bg-cover font-amiri" 
            style={{ backgroundImage: "url('/81805.jpg')" }}>
            
            <div className="absolute inset-0 bg-tertiary/60 flex flex-col justify-center items-center gap-3">
              
             <Image 
                src={image}
                alt={title}
                width={80}
                height={80}
                className="text-tertiary"
                priority
              /> 
             
              <h1 className="text-4xl md:text-5xl font-extrabold text-quaternary text-center px-4">
                {title}
              </h1>
              <p className="text-quaternary/90 text-lg">
              {length} {type} 
              </p>
            </div>
          </div>
  )
}

export default HeroSection