import React from "react";
import { usePathname } from "next/navigation";

const NavLinks = () => {
  const currentRoute = usePathname();

  const links = [
    { name: "الرئيسية", href: "/" },
    { name: "التصنيفات", href: "/categories" },
    { name: "الأسئلة و الاستشارات", href: "/qa" },
    { name: "عن الشيخ", href: "/about" },
  ];

  return (
    <nav className="hidden lg:flex items-center justify-center 2xl:gap-14 xl:gap-10 lg:gap-8 text-primary 2xl:text-[22px] xl:text-[21px] lg:text-[19px]">
      {links.map((link) => (
        <a
          key={link.name}
          href={link.href}
          className={`transition ${
            currentRoute === link.href
              ? "text-quaternary font-bold mb-2"
              : "text-primary hover:text-secondary"
          }`}
        >
          {link.name}
        </a>
      ))}
    </nav>
  );
};

export default NavLinks;
