"use client";
import { useState } from "react";
import { Menu, X } from "lucide-react";
import { usePathname } from "next/navigation";

const MobileMenu = () => {
  const [open, setOpen] = useState(false);
  const currentRoute = usePathname();
  const menuItems = [
    { name: "الرئيسية", href: "/" },
    { name: "التصنيفات", href: "/categories" },
    { name: "الأسئلة و الاستشارات", href: "/qa" },
    { name: "عن الشيخ", href: "/about" },
    { name: "بث مباشر", href: "/live-stream" },
  ];

  return (
    <div className="relative">
      {/* Hamburger / Close Button */}
      <button
        onClick={() => setOpen(!open)}
        className="p-2 text-primary focus:outline-none z-50 relative"
      >
        {open ? <X size={28} className="md:w-8 md:h-8 w-7 h-7 cursor-pointer" /> : <Menu size={28} className="md:w-8 md:h-8 w-7 h-7 cursor-pointer" />}
      </button>

      {/* Overlay */}
      <div
        className={`fixed inset-0 bg-black/30 transition-opacity duration-300 ${
          open ? "opacity-100 pointer-events-auto" : "opacity-0 pointer-events-none"
        }`}
        onClick={() => setOpen(false)}
      ></div>

      {/* Sliding Menu */}
      <div
        className={`fixed top-0 right-0 h-full w-64 bg-tertiary shadow-xl transform transition-transform duration-300 ${
          open ? "translate-x-0" : "translate-x-full"
        } flex flex-col p-6 gap-6`}
      style={{zIndex: 999}}
      >
        {menuItems.map((item) => (
          <a
            key={item.name}
            href={item.href}
            className={`${currentRoute === item.href ? "text-quaternary font-bold" : "text-primary hover:text-secondary font-medium"}text-right text-xl transition`}
            onClick={() => setOpen(false)}
          >
            {item.name}
          </a>
        ))}
      </div>
    </div>
  );
};

export default MobileMenu;



