"use client";
import React, { useState } from "react";
import { Facebook, Twitter, Instagram } from "lucide-react";
import { FaTelegramPlane, FaSoundcloud, FaYoutube } from "react-icons/fa";
import Logo from "./Header/Logo";

const Footer = () => {
  const [activeTooltip, setActiveTooltip] = useState("");

  const links = [
    { name: "الرئيسية", href: "/" },
    { name: "التصنيفات", href: "/categories" },
    { name: "الأسئلة و الاستشارات", href: "/qa" },
    { name: "عن الشيخ", href: "/about" },
    { name: "بث مباشر", href: "/live-stream" },
  ];

  const socialLinks = [
    { 
      name: "فيسبوك", 
      href: "https://www.facebook.com/DrShaal", 
      icon: <Facebook size={24} />, 
      color: "hover:text-blue-600" 
    },
    { 
      name: "تويتر", 
      href: "https://x.com/DrShaal", 
      icon: <Twitter size={24} />, 
      color: "hover:text-blue-400" 
    },
    { 
      name: "انستجرام", 
      href: "https://www.instagram.com/drr_alshaal/", 
      icon: <Instagram size={24} />, 
      color: "hover:text-pink-500" 
    },
    { 
      name: "تلجرام", 
      href: "https://telegram.me/drshaal", 
      icon: <FaTelegramPlane size={24} />, 
      color: "hover:text-sky-400" 
    },
    { 
      name: "ساوند كلاود", 
      href: "https://soundcloud.com/drshaal", 
      icon: <FaSoundcloud size={24} />, 
      color: "hover:text-orange-500" 
    },
    { 
      name: "يوتيوب", 
      href: "https://www.youtube.com/DrShaalTube", 
      icon: <FaYoutube size={24} />, 
      color: "hover:text-red-600" 
    },
    { 
      name: "ميكسلر", 
      href: "https://drshaal.mixlr.com/", 
      icon: (
        <div className="flex items-end h-6 gap-1">
          <div className="w-1 bg-current h-2"></div>
          <div className="w-1 bg-current h-3"></div>
          <div className="w-1 bg-current h-4"></div>
          <div className="w-1 bg-current h-3"></div>
          <div className="w-1 bg-current h-2"></div>
        </div>
      ), 
      color: "hover:text-purple-500" 
    },
  ];

  return (
    <footer className="bg-tertiary font-amiri text-quaternary py-12 lg:px-12 md:px-8 px-5 z-[10] w-full">
      <div className="max-w-7xl mx-auto px-6 flex flex-col lg:flex-row justify-between gap-10">
        
        {/* Logo / Info */}
        <div className="flex flex-col gap-4">
          <Logo />
          <p className="text-quaternary max-w-xs">
            موقع تعليمي يهتم بتقديم المحتوى الإسلامي بطريقة منظمة وسهلة الوصول.
          </p>
          <p className="text-sm text-gray-500">© 2025 جميع الحقوق محفوظة</p>
        </div>

        {/* Quick Links */}
        <div className="flex flex-col gap-2">
          <h2 className="font-bold text-xl text-primary mb-3">روابط سريعة</h2>
          {links.map((link) => (
            <a
              key={link.name}
              href={link.href}
              className="hover:text-secondary text-quaternary transition-colors w-fit"
            >
              {link.name}
            </a>
          ))}
        </div>

        {/* Social Icons */}
        <div className="flex flex-col gap-4">
          <h2 className="font-bold text-xl text-primary mb-3">تابعنا على</h2>
          <div className="flex gap-4 text-quaternary relative">
            {socialLinks.map((social) => (
              <div key={social.name} className="relative">
                <a
                  href={social.href}
                  className={`${social.color} transition-colors`}
                  onMouseEnter={() => setActiveTooltip(social.name)}
                  onMouseLeave={() => setActiveTooltip("")}
                >
                  {social.icon}
                </a>
                
                {/* Simple Tooltip */}
                {activeTooltip === social.name && (
                  <div className="absolute bottom-full left-1/2 transform -translate-x-1/2 mb-2">
                    <div className="bg-gray-800 text-white px-3 py-1 rounded-lg text-sm font-amiri whitespace-nowrap">
                      {social.name}
                      <div className="absolute top-full left-1/2 transform -translate-x-1/2 border-4 border-transparent border-t-gray-800"></div>
                    </div>
                  </div>
                )}
              </div>
            ))}
          </div>
        </div>

      </div>
    </footer>
  );
};

export default Footer;

