import React from 'react'
import { motion } from "framer-motion";
import Link from 'next/link'
import Image from 'next/image';
const LessonCard = ({lesson, index, mainId, subId}) => {
  return (
     <Link href={`/categories/${mainId}/${subId}/${lesson.id}`}>
              <motion.div 
              initial={{ opacity: 0, y: 30 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{
                duration: 0.3,
                delay: index * 0.2,
              }}
              whileHover={{ 
                y: -5,
                transition: { duration: 0.2 }
              }}
              whileTap={{ y: -3 }} 
               className="bg-white rounded-lg shadow-sm hover:shadow-xl transition-shadow border border-secondary/30 cursor-pointer">
                {/* Lesson Image */}
                  <div className="relative h-56 w-full">
                    <Image
                      src={lesson.image_url || '/default image.259b57e4.png'}
                      alt={lesson.title}
                      fill
                      className="object-cover"
                    />
                  </div>
                {/* Lesson title and description */}
                <div className="p-4 h-28 flex flex-col justify-center items-start">
                  <h3 className="text-xl font-bold text-quaternary mb-2 ">
                    {lesson.title}
                  </h3>
                  <p className="text-quaternary/70 text-sm line-clamp-3 leading-relaxed">
                    {lesson.description}
                  </p>
                </div>
              </motion.div>
              </Link>
  )
}

export default LessonCard